function popuprender(id) {
	window.open('/lv/renderlabels/id/'+id,'renduetq','width=400,height=200,toolbar=yes,location=yes,directories=yes,status=yes,menubar=yes,scrollbars=yes,copyhistory=yes,resizable=yes');
}

function replug() {
	$("input.adresse-updater").change(function() {
		var set = "destinataire_adresse";
		$(this).attr("id");
		$.get(
			"/ajax/adresse/id/"+$(this).val(),
			{},
			function(data) {
				$("input#"+set+"-type-"+data.type.ucfirst()).prop("checked","checked");
				$("input#"+set+"-type-"+data.type.ucfirst()).change();
				$("input#"+set+"-nom").val(data.nom);
				$("input#"+set+"-prenom").val(data.prenom);
				$("select#"+set+"-civilite").val(data.civilite);
				$("input#"+set+"-raison").val(data.raisonsociale);
				$("select#"+set+"-statut").val(data.statut);
				$("input#"+set+"-reference").val(data.reference);
				$("input#"+set+"-ligne1").val(data.ligne1);
				$("input#"+set+"-ligne2").val(data.ligne2);
				$("input#"+set+"-ligne3").val(data.ligne3);
				$("input#"+set+"-ligne4").val(data.ligne4);
				$("input#"+set+"-codepostal").val(data.codepostal);
				$("input#"+set+"-tag").val(data.tag);
				$("select#"+set+"-ville").data("lval",data.ville.toUpperCase());
				$("input#"+set+"-codepostal").change();
			},
			"json"
		);
	});
	$("input.adresse-updater:first").click();
}

String.prototype.startsWith = function(str) {
	s = str.toLowerCase();
	t = this.toLowerCase();
	for (var i = 0; i < s.length; i++) {
		if (t.charAt(i) != s.charAt(i)) return false;
	}
	return true;
};

String.prototype.form = function(data) {
	var ret = this;
	for (name in data) {
		ret = ret.replace(new RegExp("%"+ name + "%",'g'),data[name]);
	}
	return ret;
};

String.prototype.ucfirst = function() {
	return this.charAt(0).toUpperCase() + this.substr(1);
};

$(document).ready(function() {
	
	// pour retirer les noms de champ vides
	$('dt').each(function() {
		if ($(this).html() == "&nbsp;") $(this).remove();
	});
	
	// pour le formulaire de saisie de tiers
	/// marquage des balises à afficher/masquer
	$(".lgf-type-dependant").each(function() {
		var dd = $(this).parent('dd');
		var dt = $(this).parent('dd').prev('dt');
		dd.add(dt).addClass($(this).attr("class"));
		$(this).removeClass();
	});
	
	/// affichage des champs correspondant au type
	$("input.lgf-type-toggle").change(function() {
		var afficher = $(".lgf-type-"+$(this).val());
		var masquer = $(".lgf-type-dependant").not(afficher);
		afficher.slideDown();
		masquer.slideUp();
		/*afficher.each(function() {
			$(this).fadeIn();
		});
		masquer.each(function() {
			$(this).fadeOut();
		});*/
	});
	
	$("input.lgf-type-toggle").filter("input.hidden").change();
	
	$("select.tiers-updater").change(function() {
		var me = $(this);
		var tmp = me.data("template");
		var tiers = me.val();
		$.get(
			"/ajax/adresses/id/"+tiers,
			{},
			function(data) {
				$(".destinataire-adresses *").not("legend").remove();
				$(".destinataire-adresses").append(data);
				replug(); // le contenu inséré est réabonné
			},
			"html"
		);
	});
	
	/// sélection de marchandise "mixte" (combo éditable)
	$("input#submit").click(function () {
		$('input:disabled').removeAttr('disabled');
		if ($("input#commandes").val().length > 0) {
			$("button#commandes-list-add").click();
		}
		return true;
	});
	$("input.lgf-editable-combo").each(function() {
		var input = $(this);
		var select = $("select#"+input.attr("id").slice(0,-7));
		select.addClass('lgf-editable-dropdown');
		var vals = new Array();
		select.children().each(function() {
			vals.push({ "val" : $(this).val(), "text" : $(this).text() });
		});
		select.append('<option selected="selected" class="lgf-editable-dropdown-new" id="'+select.attr("id")+"-new"+'" value=""></option>');/*.attr("id",select.attr("id")+"-new").attr("name","[new]")*/
		input.data("list",vals);
		input.data("new",select.children().filter(":last-child"));
		input.data("combo",select);
		input.data("pval",input.val());
		input.width(select.width());
		select.hide();
		select.change(function() {
			input.val($(this).children().filter(":selected").text());
		});
	});
	$("input.lgf-editable-combo").keyup(function(e) {
		var input = $(this);
		if (input.data("pval") == input.val()) {
			return false;
		}
		if (e.keyCode == 8) {
			if (input.prop("selectionEnd") != input.prop("selectionStart")) {
				input.val(input.val().slice(0,-1));
				input.data("pval",input.val());
			}
			var n = input.data("new");
			n.text(input.val());
			n.attr("value",input.val());
			input.data("combo").val(input.val());
			return false;
		}
		var l = input.val().length;
		if (input.val().length > 0) {
			var match = false;
			$.each(input.data("list"), function(key, value) {
				if (value.text.startsWith(input.val())) {
					input.val(value.text);
					input.data("combo").val(value.val);
					// centrage de la vue à implémenter
					input.data("combo").change();
					input.prop("selectionStart",l);
					input.prop("selectionEnd",value.text.length);
					match = true;
					return;
				}
			});
			if (!match) {
				var n = input.data("new");
				n.text(input.val());
				n.attr("value",input.val());
				input.data("combo").val(input.val());
			}
		}
		input.data("pval",input.val());
	});
	$("button.lgf-editable-button").click(function() {
		var select = $("select#"+$(this).attr("id").slice(0,-7));
		if (!select.is(":visible")) {
			select.show();
		} else {
			select.hide();
		}
		return false;
	});
	
	/// sélection de destinataire facilitée (combo sélectable)
	$("input.lgf-selectable-combo").each(function() {
		var input = $(this);
		var select = $("select#"+input.attr("id").slice(0,-7));
		select.addClass('lgf-selectable-dropdown');
		var vals = new Array();
		select.children().each(function() {
			vals.push({ "val" : $(this).val(), "text" : $(this).text() });
		});
		input.data("list",vals);
		input.data("combo",select);
		input.data("pval",input.val());
		input.width(select.width());
		select.hide();
		select.change(function() {
			input.val($(this).children().filter(":selected").text());
		});
	});
	$("input.lgf-selectable-combo").keyup(function(e) {
		var input = $(this);
		if (input.data("pval") == input.val()) {
			return false;
		}
		if (e.keyCode == 8) {
			if (input.prop("selectionEnd") != input.prop("selectionStart")) {
				input.val(input.val().slice(0,-1));
				input.data("pval",input.val());
			}
			return false;
		}
		var l = input.val().length;
		if (input.val().length > 0) {
			$.each(input.data("list"), function(key, value) {
				if (value.text.startsWith(input.val())) {
					input.val(value.text);
					input.data("combo").val(value.val);
					// centrage de la vue à implémenter
					input.data("combo").change();
					input.prop("selectionStart",l);
					input.prop("selectionEnd",value.text.length);
					return;
				}
			});
		}
		input.data("pval",input.val());
	});
	$("input.lgf-selectable-combo").blur(function() {
		$(this).data("combo").change();
	});
	$("button.lgf-selectable-button").click(function() {
		var select = $("select#"+$(this).attr("id").slice(0,-7));
		if (!select.is(":visible")) {
			select.show();
		} else {
			select.hide();
		}
		return false;
	});
	
	/// ajout des références commandes
	$("button.lgf-lister").click(function() {
		var input = $("input#"+$(this).attr("id").slice(0,-9));
		var ul = $("ul#"+$(this).attr("id").slice(0,-4));
		if (input.val().length != 0) {
			var exists = false;
			ul.children().each(function() {
				if ($(this).children('input.lgf-lister-item').val() == input.val()) {
					exists = true;
					return;
				}
			});
			if (!exists) {
				ul.append('<li id="'+ul.attr("id")+"-"+ul.children().length+'">'+input.val()
				+'<input class="lgf-lister-item" type="hidden" name="'
				+input.attr("id")+'[]" value="'+input.val()
				+'"/><button class="lgf-lister-remove">Supprimer</button></li>');
				$("button.lgf-lister-remove").click(function() {
					$(this).parent().remove();
					return false;
				});
				input.val("");
			}
		}
		return false;
	});
	
	
	// pour formulaire et sous-formulaire d'adresse
	$("input.ville").replaceWith(function() {
		return $('<select name="'+$(this).attr('name')+'" id="'+$(this).attr('id')+'" class="'+$(this).attr('class')+'"><option>'+$(this).val()+'</option></select>').data("lval",$(this).val());
	});
	$("select.ville").attr("disabled","disabled");
	$("button.aide").click(function() {
		var pays = $("select.pays option:selected").val();
		var prefix = $(this).attr('id').slice(0,-4);
		var ville = prompt("Quelle ville cherchez-vous ?","Tapez ici le nom de la ville recherchée");
		if (ville != null) {
			$.get(
				"/ajax/codepostal/ville/"+ville+":"+pays,
				{},
				function(data2) {
					for (key in data2) {
						$("button#"+prefix+"aide").data("ville", key);
						$("input#"+prefix+"codepostal").val(data2[key]).change();
					}
				},
				"json"
			);
		}
		return false;
	});
	$("input.code").change(function() {
		var pays = $("select.pays option:selected").val();
		var prefix = $(this).attr('id').slice(0,-10);
		$.get(
			"/ajax/ville/codepostal/"+$(this).val()+":"+pays,
			{},
			function(data) {
				if (!$("#"+prefix+"ville").data("lval")) {
					$("#"+prefix+"ville").data("lval",$("#"+prefix+"ville").val());
				}
				$("#"+prefix+"ville").empty();
				if (data != null) {
					$.each(data, function (key, value) {
						$("#"+prefix+"ville").append($('<option>', {value:value}).text(value));
					});
				} else {
					$("#"+prefix+"ville").append($('<option>', {value:"nomatch"}).text("AUCUNE VILLE POUR CE CODE POSTAL"));
				}
				$("#"+prefix+"ville").removeAttr("disabled");
				if ($("#"+prefix+"ville").data("lval")) {
					$("#"+prefix+"ville").val($("#"+prefix+"ville").data("lval"));
					$("#"+prefix+"ville").removeData("lval");
				}
				if ($("button#"+prefix+"aide").data("ville")) {
					$("#"+prefix+"ville").val($("button#"+prefix+"aide").data("ville").toUpperCase().replace(/( |')/gi,"-"));
				}
			},
			"json"
		);
	});
	$("input.code").each(function() {
		if ($(this).val().length > 0) {
			$(this).change();
		}
	});
	
	$("select.pays").change(function(){ 
		$("input.code").val(''); 
		$("select.ville").val(''); 
	});
	
	// pour l'impression post-saisie LV
	if (render) {
		popuprender(render);
		window.location.replace("/lv");
	}
	$("button.renderlabels").click(function() {
		popuprender($(this).attr('id'));
	});
	$("button.lgf-cloture").click(function() {
		$(this).closest('tr').remove();
	});
	$("button#conteneurs-ajout").click(function() {
		var nb = parseInt($("input#conteneurs-nombre").val());
		var pu = parseFloat($("input#conteneurs-poids").val());
		if (nb.toString() == "NaN" || pu.toString() == "NaN") return;
		if ($("input#repartition_total").is(":checked")) pu = (pu/nb).toFixed(3);
		var type = $("select#conteneurs-marchandise").val();
		if (type.length == 0) return;
		var operateur = $("select#conteneurs-operateur").val();
		var table = $("table#detail_conteneurs").children("tbody").first();
		for ( var i = 0; i < nb && table.children("tr").length <= limcol_trans; i++) {
			var key = (Math.floor(Math.random()*10e10)).toString(36);
			table.append('<tr><td><input type="hidden" name="conteneurs[liste]['+key+'][marchandise]" value="'+type+'"/>'+type+'</td><td><input type="hidden" name="conteneurs[liste]['+key+'][poids]" value="'+pu+'"/>'+pu+' kg</td><td><input type="hidden" name="conteneurs[liste]['+key+'][operateur]" value="'+operateur+'"/>'+operateur+'</td><td class="noborder"><button type="button" class="conteneur-remove">Supprimer</button></td></tr>');
			$("button.conteneur-remove").click(function() {
				$(this).parent().parent().remove();
			});
		}
		if (table.children("tr").length == limcol_trans+1) alert('Votre transporteur accepte un maximum de '+limcol_trans+' colis par expédition. Si vous souhaitez expédier davantage de colis, créez des expéditions supplémentaires.');
	});
	
	// consultation des lv
	/// magic list
	$(".lgf-lv").click(function() {
		if ($(this).is(".lgf-lv-active")) {
			$(".lgf-lv.lgf-lv-active").removeClass("lgf-lv-active");
		} else {
			$(".lgf-lv.lgf-lv-active").removeClass("lgf-lv-active");
			$(this).addClass("lgf-lv-active");
		}
	});
	
	/// selection tout/rien
	$(".checkbox-selectall").change(function() {
		$(".checkbox-select").prop("checked", $(this).prop("checked"));
		if ($(".checkbox-select:checked").length == 0) $("#lgf-lv-list input[type=submit]").attr("disabled","disabled");
		else $("#lgf-lv-list input[type=submit]").removeAttr("disabled");
	});
	
	$(".checkbox-select").change(function() {
		if ($(".checkbox-select:checked").length == 0) $("#lgf-lv-list input[type=submit]").attr("disabled","disabled");
		else $("#lgf-lv-list input[type=submit]").removeAttr("disabled");
	});
	
	/// mass actions
	$("#lgf-lv-list input[type=submit]").attr("disabled","disabled");
	
	$("#lgf-lv-list").submit(function() {
		if (!$(this).data("ready")) return false;
		if ($(".checkbox-select:checked").length == 0) return false;
		return true;
	});
	
	$("#lgf-lv-list input[type=submit]").click(function() {
		var form = $("#lgf-lv-list");
		var action = $(this).attr("name");
		$("#lgf-lv-list").attr("action","/lv/"+action);
		if (action == "renderlabels") {
			form.attr("target","_blank");
		} else if (action == "supprimelv") {
			form.attr("target","_self");
		} else if (action == "cloturelv") {
			form.attr("target",cprint);
		}
		form.data("ready",true);
	});
});