/**
 * Fichier partiel lv-conteneurs.js
 * @author Jean Pruliere
 */

function ajoutconteneur(nb, pu, type, operateur, modulo, animation) {
	var div = $("div#detail_conteneurs");
	for ( var i = 0; i < nb && (div.children(".lgf-conteneur").length < limcol_trans || limcol_trans == 0); i++) {
		var key = (Math.floor(Math.random()*10e10)).toString(36);
		var index = div.children(".lgf-conteneur").length + 1;
		div.append('<div class="lgf-conteneur"></div>');
		var poids = pu;
		if (i == 0 && modulo != 0) {
			poids += modulo;
		}
		var cont = div.children(".lgf-conteneur").last();
		cont.append('<div class="lgf-conteneur-numero">'+index+'</div>');
		cont.append('<div class="lgf-conteneur-contenu"><div class="lgf-conteneur-label">Contenu&nbsp;:</div><div class="lgf-conteneur-value">'+((type.length > 13)?(type.substr(0,10)+'...'):type)+'</div></div>');
		cont.append('<div class="lgf-conteneur-poids"><div class="lgf-conteneur-label">Poids&nbsp;:</div><div class="lgf-conteneur-value">'+poids.toFixed(3)+' kg</div></div>');
		cont.append('<div class="lgf-conteneur-operateur"><div class="lgf-conteneur-label">Opérateur&nbsp;:</div><div class="lgf-conteneur-value">'+operateur+'</div></div>');
		cont.append('<input type="hidden" name="conteneurs[liste]['+key+'][marchandise]" value="'+type+'"/><input type="hidden" name="conteneurs[liste]['+key+'][poids]" value="'+poids+'"/><input type="hidden" name="conteneurs[liste]['+key+'][operateur]" value="'+operateur+'"/>');
		cont.click(function() {
			$(this).remove();
			var num = 1;
			div.find(".lgf-conteneur-numero").each(function() {
				$(this).text(num++);
			});
			var height = div.innerHeight();
			if (height < 22) height = 22;
			div.siblings("label.field_label").css("height", (height+5)+"px");
			div.parent("div#conteneurs-liste_group").css("height", (height+8)+"px");
		});
	}
	
	var height = div.children(".lgf-conteneur").length * 27;
	div.siblings("label.field_label").css("height", (height+5)+"px");
	if (animation) {
		div.parent("div#conteneurs-liste_group").css("height", (height+8)+"px").filter(":hidden").slideDown();
	} else {
		div.parent("div#conteneurs-liste_group").css("height", (height+8)+"px").filter(":hidden").show();
	}
	if (div.children(".lgf-conteneur").length == limcol_trans && limcol_trans > 0) alert('Votre transporteur accepte un maximum de '+limcol_trans+' colis par expédition. Si vous souhaitez expédier davantage de colis, créez des expéditions supplémentaires.');
}

$(document).ready(function() {
	$("button#conteneurs-ajout").click(function() {
		if (!$(this).hasClass("conteneurs-encore")) {
			$("#conteneurs-liste-label").css('display','block');
			var nb = parseInt($("input#conteneurs-nombre").val());
			var pu = parseFloat($("input#conteneurs-poids").val().replace(",","."));
			if (nb.toString() == "NaN" || pu.toString() == "NaN") return;
			var modulo = 0;
			if ($("input#repartition_total").is(":checked")) {
				var pt = Math.floor(pu * 1000 / nb) / 1000; // 
				modulo = Math.floor(pu * 1000 % nb) / 1000;
				pu = pt;
			}
			var type = $("#conteneurs-marchandise--edition-value").val();
			if (type.length == 0) return;
			var operateur = $("input#conteneurs-operateur").val();
			if (operateur == undefined)
				operateur = $("#conteneurs-operateur--edition-value").val();
			ajoutconteneur(nb, pu, type, operateur, modulo, true);
			$("#conteneurs-nombre_group, #conteneurs-poids_group, #conteneurs-marchandise_group, #conteneurs-operateur_group").slideUp().children("input").add("#conteneurs_group .lgf-ecombo-value").val("");
			$(this).text("Ajouter d'autres conteneurs");
		} else {
			$("#conteneurs-nombre_group, #conteneurs-poids_group, #conteneurs-marchandise_group, #conteneurs-operateur_group").slideDown();
			$(this).text("Ajouter");
			$("#conteneurs-nombre").focus();
		}
		$(this).toggleClass("conteneurs-encore");
	});
	
	$(".number").keypress(function(e) {
		if (
			(e.which >= 48 && e.which <= 57) || // un nombre
			e.key == "Tab" || // la tabulation, qui invoque keypress sous firefox
			e.which == 8 || // retour arrière
			($(this).hasClass("decimal") && (e.which == 44 || e.which == 46)) // le point et la virgule, si le champ accepte les nombres décimaux
		) ; // c'est moche dans ce sens, mais la condition est plus simple à écrire
		else return false;

		if (e.which == 46) { // on remplace via un event qui "s'autodétruit"
			$(this).keyup(function() {
				$(this).val($(this).val().replace(".",","));
				$(this).unbind('keyup');
			});
		}
	});
	
	$("form").submit(function() {
		if ($("div#detail_conteneurs").children(".lgf-conteneur").length + parseInt($("#conteneurs-nombre").val()) > limcol_trans && limcol_trans > 0) {
			var restant = limcol_trans - $("div#detail_conteneurs").children(".lgf-conteneur").length;
			alert('Votre transporteur accepte un maximum de '+limcol_trans+' colis par expédition. Merci de régulariser ceci avant d\'enregistrer. Nombre de colis restants :'+restant);
			return false;
		}
	});
	
	$(".rhi-conteneur-poids").each(function() {
		var id = $(this).attr("id").split("-")[1];
		var type = $("#rhiconteneurs-"+id+"-marchandise");
		var operateur = $("#rhiconteneurs-"+id+"-operateur");
		ajoutconteneur(1, parseFloat($(this).val()), type.val(), operateur.val(), 0, false);
		type.remove();
		operateur.remove();
		$(this).remove();
	});
});
