/**
 * Fichier partiel lv-magiclist.js
 * @author Jean Pruliere
 */

$(document).ready(function() {
	// consultation des lv
	/// magic list
	$(".lgf-lv").click(function() {
		if ($(this).is(".lgf-lv-active")) {
			$(".lgf-lv.lgf-lv-active").removeClass("lgf-lv-active");
		} else {
			$(".lgf-lv.lgf-lv-active").removeClass("lgf-lv-active");
			$(this).addClass("lgf-lv-active");
		}
	});
	
	/// selection tout/rien
	$(".checkbox-selectall").change(function() {
		$(".checkbox-select, .checkbox-selectflux").prop("checked", $(this).prop("checked"));
		if ($(".checkbox-select:checked").length == 0) $("#lgf-lv-list button").attr("disabled","disabled");
		else $("#lgf-lv-list button").removeAttr("disabled");
	});
	
	$(".checkbox-selectflux").change(function() {
		var flux = $(this).data("target");
		$(".lgf-lv-flux").filter(function(index) {
			return $(this).attr('title').trim() == flux.trim();
		}).parents('tr').find('input.checkbox-select').prop("checked", $(this).prop("checked"));
		if ($(".checkbox-select:checked").length == 0) $("#lgf-lv-list button").attr("disabled","disabled");
		else $("#lgf-lv-list button").removeAttr("disabled");
	});
	
	$(".checkbox-select").change(function() {
		if ($(".checkbox-select:checked").length == 0) $("#lgf-lv-list button").attr("disabled","disabled");
		else $("#lgf-lv-list button").removeAttr("disabled");
	});
	
	/// mass actions
	$("#lgf-lv-list button").attr("disabled","disabled");
	
	$("#lgf-lv-list").submit(function() {
		if ($(this).attr("target") == "_blank") setTimeout('window.location.reload(true);', 500);
		if (!$(this).data("ready")) return false;
		if ($(".checkbox-select:checked").length == 0) return false;
		return true;
	});
	
	$("#lgf-lv-list button").click(function() {
		var form = $("#lgf-lv-list");
		var action = $(this).attr("name");
		$("#lgf-lv-list").attr("action","/lv/"+action);
		if (action == "renderlabels" || action == "cloturelv") {
			form.attr("target","_blank");
		} else if (action == "supprimelv" || action == "demandesuppression") {
			form.attr("target","_self");
		} else if (action == "rendercontrole") {
			form.attr("target","_blank");
		}
		form.data("ready",true);
	});
});