/**
 * Fichier partiel scombo.js
 * @author Jean Pruliere
 */

String.prototype.startsWith = function(str) {
	s = str.toLowerCase();
	t = this.toLowerCase();
	for (var i = 0; i < s.length; i++) {
		if (t.charAt(i) != s.charAt(i)) return false;
	}
	return true;
};

$(document).ready(function() {
	$("form.zend_form_extended").keypress(function(e) {
		if (e.which == 13) return false;
	});
	
	// 1 remplacement
	$("select.lgf-selectable-combo").replaceWith(function() {
		var name = $(this).attr("name");
		var classes = $(this).attr("class").split(" ");
		var radioclass = name.replace(/[[\]]/g,"-")+"-option";
		var onblur = false;
		$.each(classes, function(i, _class) {
			if (_class == "lgf-editable-combo") {
				classes.splice(i,1);
			} else if (_class == "onblur") {
				classes.splice(i,1);
				onblur = true;
			}
		});
		classes.push(radioclass);
		var id = name.replace(/[[\]]/g,"-") + "-selection";
		var opts = $(this).children(); // les options du select
		/* on crée le support de remplacement :
		* - une div contenant
		*   - un input qui permet de saisir la valeur à rechercher
		*   - une ul qui contient les valeurs des options
		*/
		var inputclass = "lgf-scombo-value";
		if (onblur) {
			inputclass += " onblur";
		}
		var combo = $('<div class="lgf-scombo" id="'+id+'"><input type="text" class="'+inputclass+'" id="'+id+'-value" /><ul class="lgf-scombo-values" id="'+id+'-values"></ul></div>');
		var iterator = 0;
		opts.each(function() { // pour chaque option
			var value = $(this).val(); // on récupère la valeur
			var text = $(this).text();
			var elmid = id + "-" + iterator++;
			var checked = "";
			if ($(this).prop("selected")) {
				checked = 'checked="checked" ';
				combo.children("#"+id+"-value").val($(this).text());
			}
			var cls = "";
			if (classes.length > 0) {
				cls = ' class="'+classes.join(" ")+'"';
			}
			// pis on crée le couple radio-label dans une li
			combo.children("ul.lgf-scombo-values").append('<li><input type="radio" id="'+elmid+'"'+cls+' name="'+name+'" value="'+value+'" '+checked+'/><label for="'+elmid+'">'+text+'</label></li>');
		});
					
		return combo;
	});

	// 2 sauvegarde des valeurs
	$('.lgf-scombo-value').each(function() {
		$(this).data("pval", $(this).val()); // valeur précédente du champ, pour traiter les saisies clavier
	});

	// 3 saisie
	$('.lgf-scombo-value').not(".onblur").keyup(function(e) {
		var input = $(this);
		var ulid = input.attr("id").substring(0,input.attr("id").length-6)+"-values";
		var len = input.val().length;
		input.removeClass("lgf-nomatch");
		if (input.data("pval") == input.val()) { // cas d'une touche muette (ex: alt, ctrl)
			return false; // on arrête là
		}
		if (e.keyCode == 8) { // cas de la touche retour arrière (bsp)
			if (input.prop("selectionEnd") != input.prop("selectionStart")) { // propriété DOM définissant le caret
				/* lorsqu'une partie du texte est sélectionnée, bsp retire cette sélection.
				* le comportement souhaité ici est que la dernière lettre tapée soit retirée, la sélection ne faisant que proposer une auto-complétion 
				*/
				input.val(input.val().slice(0,-1)); // on implémente manuellement le comportement de la touche
			}
			input.data("pval",input.val());
			return false; // on ne repropose pas d'auto-complétion
		}
		var match = false;
		$("#"+ulid+" label").each(function() {
			if ($(this).text().startsWith(input.val()) && !match) {
				$("#"+$(this).attr("for")).prop("checked",true).change();
				if (document.selection) {
					var tr = input.get(0).createTextRange();
					tr.moveStart('character', len);
					tr.moveEnd('character', $(this).text().length);
					tr.select();
				} else {
					input.prop("selectionStart",len);
					input.prop("selectionEnd",$(this).text().length);
				}
				var ul = $(this).parents('ul').first();
				var li = $(this).parent('li');
				ul.scrollTop(li.prop("offsetTop") - ul.prop("clientHeight")/2 + li.prop("clientHeight")/2);
				ul.children('li').removeClass('lgf-scombo-value-selected');
				li.addClass('lgf-scombo-value-selected');
				input.data("pval",input.val());
				match = true;
			}
		});
		if (!match) {
			input.val(input.val().slice(0,-1));
			input.addClass("lgf-nomatch");
			return false;
		}
		input.data("pval",input.val());
	});

	$('.lgf-scombo-value.onblur').blur(function() {
		var input = $(this);
		var ulid = input.attr("id").substring(0,input.attr("id").length-6)+"-values";
		var len = input.val().length;
		input.removeClass("lgf-nomatch");
		if (input.data("pval") == input.val()) { // cas d'une touche muette (ex: alt, ctrl)
			return false; // on arrête là
		}
		var match = false;
		$("#"+ulid+" label").each(function() {
			if ($(this).text().startsWith(input.val()) && !match) {
				$("#"+$(this).attr("for")).prop("checked",true).change();
				if (document.selection) {
					var tr = input.get(0).createTextRange();
					tr.moveStart('character', len);
					tr.moveEnd('character', $(this).text().length);
					tr.select();
				} else {
					input.prop("selectionStart",len);
					input.prop("selectionEnd",$(this).text().length);
				}
				var ul = $(this).parents('ul').first();
				var li = $(this).parent('li');
				ul.scrollTop(li.prop("offsetTop") - ul.prop("clientHeight")/2 + li.prop("clientHeight")/2);
				ul.children('li').removeClass('lgf-scombo-value-selected');
				li.addClass('lgf-scombo-value-selected');
				input.data("pval",input.val());
				match = true;
			}
		});
		if (!match) {
			input.val("");
			input.addClass("lgf-nomatch");
			return false;
		}
		input.data("pval",input.val());
		$("#valeur_declaree").focus();
	}).keypress(function(e) {
		if (e.which == 13) {
			$(this).blur();
			return false;
		}
	});

	// 4 changement
	$("ul.lgf-scombo-values input[type=radio]").change(function() {
		var ulid = $(this).parents('ul').attr("id");
		var inputid = ulid.substring(0,ulid.length-1);
		$("." + $(this).attr("class")).removeAttr("checked");
		$(this).attr("checked", "checked");
		$("#"+inputid).val($(this).siblings('label').text());
		$(this).parents('ul').children('li').removeClass('lgf-scombo-value-selected');
		$(this).parent().addClass('lgf-scombo-value-selected');
	});

	// 5 sélection
	$("ul.lgf-scombo-values li").click(function() {
		$(this).children("input[type=radio]").change();
	});
});